<?php

require_once ("HTML/Table.php");


// konfigurowanie atrybutw tabeli za pomoc typowych atrybutw HTML
// penicych rol kluczy tablicy
$attributes = array("width" => "50%", "border" => "1");

// tworzenie obiektu nowej tabeli
$table = new HTML_Table($attributes);

// konfigurowane tabeli
// waciwo AutoGrow stosowana jest przy nieznanej liczbie wierszy
// waciwo AutoFill wstawia tekst do kadej pustej komrki
// Udajemy, e nie wiemy jak wielka bdzie nasza tabela,
// dlatego wypeniamy obie te waciwoci.
$table -> setAutoGrow(true);
$table -> setAutoFill("-");


// pobieramy dane dla naszej tabeli
$rows = array(
 '0' => array("Numer jeden", "Numer dwa", "Numer trzy"),
 '1' => array("Numero Uno", "Numero Dos", "Numero Tres"),
);

// wypeniamy tabel danymi
for($nr = 0; $nr < count($rows); $nr++) {
 // Na pocztek wiersz nagwka
	$table -> setHeaderContents( $nr+1, 0, (string)$nr);
 for($i = 0; $i < 3; $i++) {
  if("" != $rows[$nr][$i])
 // a nastpnie poszczeglne wiersze
  $table -> setCellContents( $nr+1, $i+1, $rows[$nr][$i]);
 }
}

// ustalamy to co drugiego wiersza tabeli
// pomijamy pierwszy wiersz, wic na pocztek uyjemy wartoci 1
$altRow = array("bgcolor"=>"#FFFFCC");
$table -> altRowAttributes(1, null, $altRow);

// Ustalamy informacje dla nagwkw poszczeglnych kolumn.
// Wsprzdne 0,0 opisuj komrk w lewym grnym rogu.
// Trzecia warto to tekst, jaki ma si pojawi w komrce.
$table -> setHeaderContents(0, 0, " ");
$table -> setHeaderContents(0, 1, "Pole 1");
$table -> setHeaderContents(0, 2, "Pole 2");
$table -> setHeaderContents(0, 3, "Pole 3");

// Ustalamy atrybuty wiersza nagwkowego i pierwszej kolumny.
// Pierwszy wiersz i kolumna maj indeks zerowy.
$hrAttrs = array("bgcolor" => "#FFFF4D");
$table -> setRowAttributes(0, $hrAttrs, true);
$table -> setColAttributes(0, $hrAttrs);

// Wysyamy tabel do przegldarki
echo $table->toHTML();


?>
